<?php

trait GalaxPaySubscription
{

    protected function processSubscription()
    {
        $this->checkInstallments();
        //tinha aqui um if de isRenewalOrder, mas pra gente nao faz sentido, nao conseguimos controlar isso apenas adiocionando transacao
        //tem que adicionar contrato de novo, entao segue o mesmo processo de venda normalmente.
        return $this->processInscription($this->typePayment);
    }

    protected function processInscription($type = 'card')
    {
        $subscription = $this->createSubscription($type);
        /* da erro no plugin que cria a assinatura depois
          $wc_subscriptions = wcs_get_subscriptions_for_order($this->order);
          if (count($wc_subscriptions) == 0) {
          $message = 'Não foram encontradas assinaturas para processar.';
          $this->order->update_status('failed', $message);
          throw new \Exception($message);
          }
          $wc_subscription = end($wc_subscriptions); */

        $customerId = $subscription['Customer']['galaxPayId'];
        $subscriptionId = $subscription['galaxPayId'];

        add_post_meta($this->order->id, 'galaxPayBill', $subscriptionId);
        add_post_meta($this->order->id, 'galaxCustomerId', $customerId);
        /* add_post_meta($this->order->id, 'subscriptionId', $wc_subscription->id);
          add_post_meta($wc_subscription->id, 'galaxPayBill', $subscriptionId);
          add_post_meta($wc_subscription->id, 'galaxCustomerId', $customerId); */

        return $this->finishSubscription($subscription);
    }

    protected function finishSubscription($bill)
    {
        $this->container->woocommerce->cart->empty_cart();

        $type = 'success';

        $statusPayment = $bill['Transactions'][0]['status'];

        if ($statusPayment == 'captured') {
            $status = $this->container->getReturnStatusSubscription();
            $status_message = __('O Pagamento foi realizado com sucesso pelo Galax Pay.', GALAX_IDENTIFIER);
        } elseif ($statusPayment == 'denied') {
            $status = 'cancelled';
            $status_message = 'Primeira transação foi negada, portanto pedido é cancelado.';
            $this->container->api->cancelSubscription($bill['myId']);
        } else {
            $data_to_log = sprintf('Aguardando pagamento do pedido %s pelo Galax Pay.', $this->order->id);
            $status_message = __('Aguardando pagamento do pedido.', GALAX_IDENTIFIER);
            $status = 'pending';
            $this->container->logger->log($data_to_log);
        }
        $this->order->update_status($status, $status_message);

        return array(
            'result' => $type,
            'redirect' => $this->order->get_checkout_order_received_url(),
        );
    }

    private function existsOnGalaxPay($id)
    {
        $bill = $this->container->api->getSubscriptionById($id);
        if ($bill['totalQtdFoundInPage'] == 1) {
            return true;
        }
        return false;
    }

    private function retryPayment()
    {
        $body = $this->getCommonBody('subscription');
        $bill = $this->container->api->retrySubscription($this->order->id, $body);
        return $bill;
    }

    protected function createSubscription($type = 'card')
    {

        $body = $this->getCommonBody('subscription');

        if ($this->existsOnGalaxPay($this->order->id)) {
            $response = $this->retryPayment();
        } else {
            $wcSubscription = $this->getSubscription();
            $body['periodicity'] = $this->getPeriodicityData($wcSubscription);
            $body['quantity'] = $this->getQuantitySubscription();
            $body['Transactions'] = $this->getTransactionsSubscription($body);
            $response = $this->container->api->createSubscription($body);
        }

        if ($response['type'] !== true) {
            $this->container->logger->log(sprintf('Erro no pagamento do pedido.', $this->order->id));
            $message = sprintf(__('Pagamento Falhou.', GALAX_IDENTIFIER), $this->container->api->last_error);
            $this->order->update_status('failed', $message);
            throw new \Exception($message);
        }
        WC()->session->__unset('current_customer');
        return $response['Subscription'];
    }

}
