<?php

class GalaxPayLogger
{

    private $identifier;
    private $main_logger;
    private $is_active;

    public function __construct($identifier, $is_active)
    {
        $this->main_logger = new WC_Logger();
        $this->identifier = $identifier;
        $this->is_active = $is_active;
    }

    public function log($message)
    {
        if (GALAXPAY_DEBUG) {
            echo '<hr>';
            echo ($message);
            echo '<hr>';
        }
        if (GALAXPAY_DEEP_LOG) {
            $file_log =   __DIR__ . '/logs/log-geral_' . date('Ymd') . '.txt';
            $fp = fopen($file_log, "a+");
            fwrite($fp, $message);
            fclose($fp);
        }
        if ($this->is_active) {
            $this->main_logger->add($this->identifier, $message);
            return true;
        }

        return false;
    }
}
