<?php

if (!function_exists('get_plugins')) {
    require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}

//Classe de dependências
//faz a validação dos plugins instalados para que o nosso funcione
class GalaxPayDependencies
{

    private static $active_plugins;

    public static function init()
    {
        self::$active_plugins = (array) get_option('active_plugins', array());

        if (is_multisite()) {
            self::$active_plugins = array_merge(self::$active_plugins, get_site_option('active_sitewide_plugins', array()));
        }
    }

    public static function check()
    {
        if (!self::$active_plugins) {
            self::init();
        }
        $required_plugins = [
            [
                'path' => 'woocommerce/woocommerce.php',
                'plugin' => [
                    'name' => 'WooCommerce',
                    'url' => 'https://wordpress.org/extend/plugins/woocommerce/',
                    'version' => [
                        'validation' => '>=',
                        'number' => '3.0'
                    ]
                ]
            ],
            [
                'path' => 'woocommerce-extra-checkout-fields-for-brazil/woocommerce-extra-checkout-fields-for-brazil.php',
                'plugin' => [
                    'name' => 'WooCommerce Extra Checkout Fields for Brazil',
                    'url' => 'https://wordpress.org/extend/plugins/woocommerce-extra-checkout-fields-for-brazil/',
                    'version' => [
                        'validation' => '>=',
                        'number' => '3.5'
                    ]
                ]
            ]
        ];

        self::wc_subscriptions_are_activated();

        foreach ($required_plugins as $plugin) {
            if (self::plugin_is_active($plugin) == false) {
                self::missing_notice($plugin['plugin']['name'], $plugin['plugin']['version']['number'], $plugin['plugin']['url']);
                return false;
            }

            if (self::verify_version_of_plugin($plugin) == false) {
                return false;
            }
        }
        return true;
    }

    public static function missing_notice($name, $version, $link)
    {
        echo '<div class="error"><p>' . sprintf(__('O  Plugin Galax Pay WooCommerce depende da versão %s do %s para funcionar!', GALAX_IDENTIFIER), $version, "<a href=\"{$link}\">" . __($name, GALAX_IDENTIFIER) . '</a>') . '</p></div>';
    }

    public static function plugin_is_active($plugin)
    {
        if (in_array($plugin['path'], self::$active_plugins)) {
            return true;
        }

        return false;
    }

    public static function verify_version_of_plugin($plugin)
    {
        $plugin_data = get_plugin_data(plugin_dir_path(__DIR__) . "../" . $plugin['path']);
        $version_match = $plugin['plugin']['version'];
        $version_compare = version_compare(
                $plugin_data['Version'], $version_match['number'], $version_match['validation']
        );

        if ($version_compare == false) {
            add_action(
                    'admin_notices', self::missing_notice($plugin['plugin']['name'], $version_match['number'], $plugin['plugin']['url'])
            );

            return false;
        }

        return true;
    }

    public static function wc_subscriptions_are_activated()
    {
        $wc_subscriptions = [
            'path' => 'woocommerce-subscriptions/woocommerce-subscriptions.php',
            'plugin' => [
                'name' => 'WooCommerce Subscriptions',
                'url' => 'http://www.woothemes.com/products/woocommerce-subscriptions/',
                'version' => [
                    'validation' => '>=',
                    'number' => '2.2'
                ]
            ],
        ];

        if (self::plugin_is_active($wc_subscriptions)) {
            if (self::verify_version_of_plugin($wc_subscriptions)) {
                return true;
            }
        }

        return false;
    }

}
