<?php

class GalaxPayChargeStatus
{
    
    public function __construct(GalaxPaySettings $container)
    {
        $this->container = $container;
        add_action('woocommerce_order_status_changed', array(&$this, 'updateStatus'));
    }

    public function updateStatus($orderId)
    {
        if (defined('IS_WEBHOOK') || defined('IS_PROCESS_PAYMENT')) {
            return;
        }
        
        $order = new WC_Order($orderId);
        
        $statusToCancel = ['cancelled', 'failed'];
        $idBill = end(get_post_meta($orderId, 'galaxPayBill'));
        $hasSubscription = end(wcs_get_subscriptions_for_order($orderId));
        if (!$hasSubscription) {
            if (in_array($order->status, $statusToCancel)) {
                $this->container->api->cancelCharge($idBill, 'galaxPayId');
                $order->add_order_note('Venda #'.$idBill.' cancelada no Galax Pay');
            } else if ($order->status == "completed") {
                $this->putPayedOutsideGalaxPay($idBill);
                $order->add_order_note('Venda #'.$idBill.' alterada para "paga fora do sistema" no Galax Pay');
            }
        }
    }
    
    private function putPayedOutsideGalaxPay($idBill)
    {
        $body = [
            'payedOutsideGalaxPay' => true
        ];
        $this->container->api->editCharge($idBill, $body);
    }
    
}
