<?php



//Pix no Boleto

class GalaxPayPixBoleto extends GalaxPayBaseGateway

{



    public function __construct(GalaxPaySettings $container)

    {

        $this->id = 'galax-pay-boletopix';

        $this->method_description = 'Pagamentos via pix processados pelo Galax Pay.';

        $this->method_title = __('Galax Pay - Pix', GALAX_IDENTIFIER);

        $this->has_fields = true;



        $this->init_form_fields();

        $this->init_settings();



        add_action('woocommerce_thankyou_' . $this->id, array(&$this, 'thank_you_page'));

        add_filter('woocommerce_my_account_my_orders_actions', array(&$this, 'my_account_print_buttons'), 10, 2);



        $this->supports  = GalaxPaySettings::getSupports();

        parent::__construct($container);
    }



    public function is_available()

    {

        if (is_checkout() == false) {

            return false;
        }



        return $this->enabled && $this->container->api->accept_bank_slip() && $this->container->check_ssl() == 'yes';
    }



    public function payment_fields()

    {

        $is_single_order = $this->is_single_order();

        $this->container->get_template('boletopix-checkout.html.php', compact('is_single_order'));
    }



    public function thank_you_page($order_id)

    {

        $response = $this->container->api->getChargeByMyId($order_id);

        $name = 'Charges';

        if ($response['totalQtdFoundInPage'] == 0) {

            $response = $this->container->api->getSubscriptionById($order_id);

            $name = 'Subscriptions';
        }

        $transaction = $response[$name]['0']['Transactions']['0'];

        if (!empty($transaction['Pix']['page'])) {

            $download_url = $transaction['Pix']['page'];

            $this->container->get_template('boletopix-download.html.php', compact('download_url'));
        }
    }



    public function init_form_fields()

    {

        $this->form_fields = array(

            'enabled' => array(

                'title' => __('Habilitar/Desabilitar', GALAX_IDENTIFIER),

                'label' => __('Habilitar pagamento por Pix com o Galax Pay', GALAX_IDENTIFIER),

                'type' => 'checkbox',

                'default' => 'no',

            ),

            'title' => array(

                'title' => __('Título', GALAX_IDENTIFIER),

                'type' => 'text',

                'description' => __('Título que o cliente verá durante o processo de pagamento.', GALAX_IDENTIFIER),

                'default' => __('Pix', GALAX_IDENTIFIER),

            )

        );
    }



    public function my_account_print_buttons($actions, $order)

    {

        if ($this->id !== $order->get_payment_method()) {

            return $actions;
        }



        $response = $this->container->api->getChargeByMyId($order->id);

        $transaction = $response['Charges']['0']['Transactions']['0'];

        $link = $transaction['Pix']['page'];

        if (!empty($link)) {

            $actions[$this->id . '-print'] = array(

                'url'  => \esc_url($link),

                'name' => __('Visualizar Pix', GALAX_IDENTIFIER),

            );
        }



        return $actions;
    }
}
